<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.4.3.111.3.9.10.23
Name: Bestand Download En Validatie
Description: 
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" id="template-2.16.840.1.113883.2.4.3.111.3.9.10.23-2016-10-13T124425">
    <title>Bestand Download En Validatie</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.23
Context: /
Item: (RCMR_IN000102NL)
-->
    <rule context="/" id="d836099e2047-false-d850746e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:RCMR_IN000102NL)&gt;=1">(RCMR_IN000102NL): element hl7:RCMR_IN000102NL is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:RCMR_IN000102NL)&lt;=1">(RCMR_IN000102NL): element hl7:RCMR_IN000102NL komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.23
Context: /hl7:RCMR_IN000102NL
Item: (RCMR_IN000102NL)
-->
    <rule context="/hl7:RCMR_IN000102NL" id="d836099e2051-false-d850769e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="hl7:acceptAckCode/@code = 'AL'">(RCMR_IN000102NL): hl7:acceptAckCode/@code moet de waarde “AL” bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(RCMR_IN000102NL): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:id[not(@nullFlavor)])&lt;=1">(RCMR_IN000102NL): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:creationTime[not(@nullFlavor)])&gt;=1">(RCMR_IN000102NL): element hl7:creationTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:creationTime[not(@nullFlavor)])&lt;=1">(RCMR_IN000102NL): element hl7:creationTime[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)])&gt;=1">(RCMR_IN000102NL): element hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)])&lt;=1">(RCMR_IN000102NL): element hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:interactionId[@root='2.16.840.1.113883.1.6'])&gt;=1">(RCMR_IN000102NL): element hl7:interactionId[@root='2.16.840.1.113883.1.6'] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:interactionId[@root='2.16.840.1.113883.1.6'])&lt;=1">(RCMR_IN000102NL): element hl7:interactionId[@root='2.16.840.1.113883.1.6'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1'])&gt;=1">(RCMR_IN000102NL): element hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1'] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1'])&lt;=1">(RCMR_IN000102NL): element hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:processingCode[@code='P'][not(@nullFlavor)])&gt;=1">(RCMR_IN000102NL): element hl7:processingCode[@code='P'][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:processingCode[@code='P'][not(@nullFlavor)])&lt;=1">(RCMR_IN000102NL): element hl7:processingCode[@code='P'][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:processingModeCode[@code='T'][not(@nullFlavor)])&gt;=1">(RCMR_IN000102NL): element hl7:processingModeCode[@code='T'][not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:processingModeCode[@code='T'][not(@nullFlavor)])&lt;=1">(RCMR_IN000102NL): element hl7:processingModeCode[@code='T'][not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:acceptAckCode[not(@nullFlavor)])&gt;=1">(RCMR_IN000102NL): element hl7:acceptAckCode[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:acceptAckCode[not(@nullFlavor)])&lt;=1">(RCMR_IN000102NL): element hl7:acceptAckCode[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:acknowledgement[not(@nullFlavor)])&gt;=1">(RCMR_IN000102NL): element hl7:acknowledgement[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:acknowledgement[not(@nullFlavor)])&lt;=1">(RCMR_IN000102NL): element hl7:acknowledgement[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:receiver)&gt;=1">(RCMR_IN000102NL): element hl7:receiver is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:receiver)&lt;=1">(RCMR_IN000102NL): element hl7:receiver komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:sender[not(@nullFlavor)])&gt;=1">(RCMR_IN000102NL): element hl7:sender[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:sender[not(@nullFlavor)])&lt;=1">(RCMR_IN000102NL): element hl7:sender[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <let name="transmission" value="."/>
        <let name="interactionId" value="$transmission/local-name()"/>
        <let name="interactionVocabFile" value="'../vocab/2.16.840.1.113883.1.6.xml'"/>
        <let name="interactionVocab" value="if (doc-available($interactionVocabFile)) then doc($interactionVocabFile) else ()"/>
        <let name="interactionName" value="$interactionVocab/*/hl7:code[@code=$interactionId]/@displayName"/>
        <let name="isActive" value="not(exists($interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Actief'][@value='false']))"/>
        <let name="allowBsn" value="exists($interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='AttentionLineMetBsn'][@value='true'])"/>
        <let name="allowContextCode" value="exists($interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='AttentionLineMetContextCode'][@value='true'])"/>
        <let name="senderGbpOrGbk" value="exists($transmission/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:code[@codeSystem=('2.16.840.1.113883.2.4.3.11.8','2.16.840.1.113883.2.4.3.11.6')])"/>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="$interactionVocab">(RCMR_IN000102NL): Transmission: <value-of select="$interactionVocabFile"/> niet gevonden. Controles gebaseerd op dit externe configuratiebestand zijn gedeactiveerd.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($interactionVocab) or $isActive">(RCMR_IN000102NL): Transmission: deze interactie <value-of select="$interactionId"/> (<value-of select="$interactionName"/>) is niet (meer) Actief in <value-of select="$interactionVocabFile"/>
        </assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($interactionVocab) or not($allowBsn) or $transmission/hl7:attentionLine/hl7:keyWordText[@code=('FICID','PATID')][@codeSystem='2.16.840.1.113883.2.4.15.1']">(RCMR_IN000102NL): Transmission: er moet in deze interactie exact één AttentionLine met BSN zitten - <value-of select="$interactionId"/> (<value-of select="$interactionName"/>)</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($interactionVocab) or  not($allowContextCode) or $transmission/hl7:attentionLine/hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']">(RCMR_IN000102NL): Transmission: er moet in deze interactie exact één AttentionLine met de ContextCode zitten - <value-of select="$interactionId"/> (<value-of select="$interactionName"/>)</assert>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($interactionVocab) or not($transmission/hl7:attentionLine/hl7:keywordText[@code=('FICID','PATID')][@codeSystem='2.16.840.1.113883.2.4.15.1']) or $allowBsn or $senderGbpOrGbk">(RCMR_IN000102NL): Transmission: deze interactie <value-of select="$interactionId"/> (<value-of select="$interactionName"/>) is niet geconfigureerd voor gebruik van het element <value-of select="local-name()"/> voor BSN in <value-of select="$interactionVocabFile"/> en afzender is niet GBK of GBP</assert>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($interactionVocab) or not($transmission/hl7:attentionLine/hl7:keywordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1']) or $allowContextCode or $senderGbpOrGbk">(RCMR_IN000102NL): Transmission: deze interactie <value-of select="$interactionId"/> (<value-of select="$interactionName"/>) is niet geconfigureerd voor gebruik van het element <value-of select="local-name()"/> voor ContextCode in <value-of select="$interactionVocabFile"/> en afzender is niet GBK of GBP</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count($transmission/hl7:attentionLine/hl7:keyWordText[@code=('FICID','PATID')][@codeSystem='2.16.840.1.113883.2.4.15.1'])&lt;=1">(RCMR_IN000102NL): Transmission: er mag maximaal één AttentionLine met BSN zijn - <value-of select="$interactionId"/> (<value-of select="$interactionName"/>)</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count($transmission/hl7:attentionLine/hl7:keyWordText[@code='CONTEXT'][@codeSystem='2.16.840.1.113883.2.4.15.1'])&lt;=1">(RCMR_IN000102NL): Transmission: er mag maximaal één AttentionLine met de ContextCode zijn - <value-of select="$interactionId"/> (<value-of select="$interactionName"/>)</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:id[not(@nullFlavor)]
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:id[not(@nullFlavor)]" id="d850773e141-false-d850929e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300asynchroon): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="@root and @extension">(MCCI_MT000300asynchroon): Transmission: id element mist root of extension</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:creationTime[not(@nullFlavor)]
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:creationTime[not(@nullFlavor)]" id="d850773e146-false-d850942e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300asynchroon): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS.DATETIME.MIN"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="not(*)">(MCCI_MT000300asynchroon): <value-of select="local-name()"/> met datatype TS.DATETIME.MIN, MAG GEEN elementen bevatten.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)]
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:versionCode[@code='NICTIZEd2005-Okt'][not(@nullFlavor)]" id="d850773e151-false-d850958e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300asynchroon): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="@nullFlavor or (@code='NICTIZEd2005-Okt')">(MCCI_MT000300asynchroon): de elementwaarde MOET een zijn van 'code 'NICTIZEd2005-Okt''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:interactionId[@root='2.16.840.1.113883.1.6']
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:interactionId[@root='2.16.840.1.113883.1.6']" id="d850773e155-false-d850977e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300asynchroon): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="string(@root)=('2.16.840.1.113883.1.6')">(MCCI_MT000300asynchroon): de waarde van @root MOET '2.16.840.1.113883.1.6' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(MCCI_MT000300asynchroon): attribuut @root MOET datatype 'uid' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="not(@root='2.16.840.1.113883.1.6') or local-name(..)=@extension">(MCCI_MT000300asynchroon): Transmission: @extension moet overeenkomen met het startelement van het bericht</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1']
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1']" id="d850773e161-false-d850997e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300asynchroon): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="string(@root)=('2.16.840.1.113883.2.4.3.11.1')">(MCCI_MT000300asynchroon): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.1' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(MCCI_MT000300asynchroon): attribuut @root MOET datatype 'uid' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="string(@extension)=('810')">(MCCI_MT000300asynchroon): de waarde van @extension MOET '810' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="not(@extension) or string-length(@extension)&gt;0">(MCCI_MT000300asynchroon): attribuut @extension MOET datatype 'st' hebben</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:processingCode[@code='P'][not(@nullFlavor)]
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:processingCode[@code='P'][not(@nullFlavor)]" id="d850773e167-false-d851024e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300asynchroon): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="@nullFlavor or (@code='P')">(MCCI_MT000300asynchroon): de elementwaarde MOET een zijn van 'code 'P''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:processingModeCode[@code='T'][not(@nullFlavor)]
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:processingModeCode[@code='T'][not(@nullFlavor)]" id="d850773e171-false-d851043e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300asynchroon): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="@nullFlavor or (@code='T')">(MCCI_MT000300asynchroon): de elementwaarde MOET een zijn van 'code 'T''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:acceptAckCode[not(@nullFlavor)]
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:acceptAckCode[not(@nullFlavor)]" id="d850773e175-false-d851062e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300asynchroon): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CS"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:acknowledgement[not(@nullFlavor)]
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:acknowledgement[not(@nullFlavor)]" id="d850773e178-false-d851075e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="@typeCode">(MCCI_MT000300asynchroon): attribute @typeCode MOET aanwezig zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="not(@typeCode) or (string-length(@typeCode)&gt;0 and not(matches(@typeCode,'\s')))">(MCCI_MT000300asynchroon): attribuut @typeCode MOET datatype 'cs' hebben</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@typeCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.8-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="not(@typeCode) or count($theAttValue) = count($theAttCheck)">(MCCI_MT000300asynchroon): de waarde van typeCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.8' AcknowledgementType (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="count(hl7:targetMessage[not(@nullFlavor)])&gt;=1">(MCCI_MT000300asynchroon): element hl7:targetMessage[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="count(hl7:targetMessage[not(@nullFlavor)])&lt;=1">(MCCI_MT000300asynchroon): element hl7:targetMessage[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:acknowledgementDetail
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:acknowledgementDetail" id="d850773e187-false-d851120e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="not(@typeCode) or (string-length(@typeCode)&gt;0 and not(matches(@typeCode,'\s')))">(MCCI_MT000300asynchroon): attribuut @typeCode MOET datatype 'cs' hebben</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@typeCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.19358-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="not(@typeCode) or count($theAttValue) = count($theAttCheck)">(MCCI_MT000300asynchroon): de waarde van typeCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.19358' AcknowledgementDetailType (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="count(hl7:code)&lt;=1">(MCCI_MT000300asynchroon): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="count(hl7:text)&lt;=1">(MCCI_MT000300asynchroon): element hl7:text komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:acknowledgementDetail/hl7:code
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:acknowledgementDetail/hl7:code" id="d850773e192-false-d851168e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300asynchroon): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:acknowledgementDetail/hl7:text
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:acknowledgementDetail/hl7:text" id="d850773e195-false-d851181e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300asynchroon): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ST"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:acknowledgementDetail/hl7:location
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:acknowledgementDetail/hl7:location" id="d850773e198-false-d851194e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ST' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300asynchroon): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ST" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ST"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:targetMessage[not(@nullFlavor)]
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:targetMessage[not(@nullFlavor)]" id="d850773e201-false-d851207e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(MCCI_MT000300asynchroon): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="count(hl7:id[not(@nullFlavor)])&lt;=1">(MCCI_MT000300asynchroon): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:targetMessage[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:acknowledgement[not(@nullFlavor)]/hl7:targetMessage[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]" id="d850773e204-false-d851229e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300asynchroon): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.120
Context: /hl7:RCMR_IN000102NL/hl7:attentionLine
Item: (TransmissionWrapperAttentionLine)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:attentionLine" id="d851230e20-false-d851242e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="count(hl7:keyWordText[not(@nullFlavor)])&gt;=1">(TransmissionWrapperAttentionLine): element hl7:keyWordText[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="count(hl7:keyWordText[not(@nullFlavor)])&lt;=1">(TransmissionWrapperAttentionLine): element hl7:keyWordText[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="count(hl7:value[not(@nullFlavor)])&gt;=1">(TransmissionWrapperAttentionLine): element hl7:value[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="count(hl7:value[not(@nullFlavor)])&lt;=1">(TransmissionWrapperAttentionLine): element hl7:value[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.120
Context: /hl7:RCMR_IN000102NL/hl7:attentionLine/hl7:keyWordText[not(@nullFlavor)]
Item: (TransmissionWrapperAttentionLine)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:attentionLine/hl7:keyWordText[not(@nullFlavor)]" id="d851230e23-false-d851276e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='SC' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperAttentionLine): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:SC" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="SC"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.120
Context: /hl7:RCMR_IN000102NL/hl7:attentionLine/hl7:value[not(@nullFlavor)]
Item: (TransmissionWrapperAttentionLine)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:attentionLine/hl7:value[not(@nullFlavor)]" id="d851230e32-false-d851289e0">
        <extends rule="ANY"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.120" test="@xsi:type">(TransmissionWrapperAttentionLine): attribute @xsi:type MOET aanwezig zijn.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:receiver
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver" id="d850773e208-false-d851303e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="string(@typeCode)=('RCV') or not(@typeCode)">(MCCI_MT000300asynchroon): de waarde van @typeCode MOET 'RCV' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="not(@typeCode) or (string-length(@typeCode)&gt;0 and not(matches(@typeCode,'\s')))">(MCCI_MT000300asynchroon): attribuut @typeCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="count(hl7:device[not(@nullFlavor)])&gt;=1">(MCCI_MT000300asynchroon): element hl7:device[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="count(hl7:device[not(@nullFlavor)])&lt;=1">(MCCI_MT000300asynchroon): element hl7:device[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]" id="d851313e22-false-d851335e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.6'])&gt;=1">(TransmissionWrapperDevice): element hl7:id[@root='2.16.840.1.113883.2.4.6.6'] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.6'])&lt;=1">(TransmissionWrapperDevice): element hl7:id[@root='2.16.840.1.113883.2.4.6.6'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:name)&lt;=1">(TransmissionWrapperDevice): element hl7:name komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:agencyFor)&lt;=1">(TransmissionWrapperDevice): element hl7:agencyFor komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.6']
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.6']" id="d851313e25-false-d851375e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@root)=('2.16.840.1.113883.2.4.6.6')">(TransmissionWrapperDevice): de waarde van @root MOET '2.16.840.1.113883.2.4.6.6' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="@extension">(TransmissionWrapperDevice): attribute @extension MOET aanwezig zijn.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:name
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:name" id="d851313e30-false-d851396e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='EN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:EN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="EN"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor" id="d851313e33-false-d851409e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('AGNT') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'AGNT' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:representedOrganization)&lt;=1">(TransmissionWrapperDevice): element hl7:representedOrganization komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization" id="d851313e37-false-d851431e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('ORG') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'ORG' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(TransmissionWrapperDevice): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(TransmissionWrapperDevice): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[not(@nullFlavor)])&lt;=1">(TransmissionWrapperDevice): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:NotificationParty)&lt;=1">(TransmissionWrapperDevice): element hl7:NotificationParty komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:id[not(@nullFlavor)]
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:id[not(@nullFlavor)]" id="d851313e40-false-d851482e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:name
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:name" id="d851313e43-false-d851495e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:telecom
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:telecom" id="d851313e46-false-d851508e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty" id="d851313e49-false-d851522e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('CON') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'CON' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:contactParty)&gt;=1">(TransmissionWrapperDevice): element hl7:contactParty is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:contactParty)&lt;=1">(TransmissionWrapperDevice): element hl7:contactParty komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:id
Item: (COCT_MT040203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:id" id="d851528e18-false-d851571e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:code
Item: (COCT_MT040203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:code" id="d851528e19-false-d851584e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:addr
Item: (COCT_MT040203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:addr" id="d851528e20-false-d851597e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:telecom
Item: (COCT_MT040203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:telecom" id="d851528e21-false-d851610e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty
Item: (COCT_MT040203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty" id="d851528e22-false-d851623e0">
        <let name="elmcount" value="count(hl7:Organization|hl7:Person)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="$elmcount&gt;=1">(COCT_MT040203): keuze (hl7:Organization of hl7:Person) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="$elmcount&lt;=1">(COCT_MT040203): keuze (hl7:Organization of hl7:Person) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="count(hl7:Organization)&lt;=1">(COCT_MT040203): element hl7:Organization komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="count(hl7:Person)&lt;=1">(COCT_MT040203): element hl7:Person komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization
Item: (COCT_MT040203)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('ORG') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'ORG' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT150003): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:id)&gt;=1">(COCT_MT150003): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:code)&lt;=1">(COCT_MT150003): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:contact)&gt;=1">(COCT_MT150003): element hl7:contact is required [min 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:id
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:code
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:name
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:name">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('CON') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'CON' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:code)&lt;=1">(COCT_MT150003): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:contactPerson)&lt;=1">(COCT_MT150003): element hl7:contactPerson komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:id
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:code
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:addr
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:telecom
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson">
        <extends rule="d851847e22-false-d852541e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT150003): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:name)&gt;=1">(COCT_MT150003): element hl7:name is required [min 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name">
        <extends rule="d852527e21-false-d852616e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId">
        <extends rule="d852527e31-false-d852775e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson
Item: (COCT_MT030203)
-->
    <rule id="d851847e22-false-d852541e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT030203): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT030203): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:id)&gt;=1">(COCT_MT030203): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:administrativeGenderCode)&lt;=1">(COCT_MT030203): element hl7:administrativeGenderCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:birthTime)&lt;=1">(COCT_MT030203): element hl7:birthTime komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:id
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name
Item: (COCT_MT030203)
-->
    <rule id="d852527e21-false-d852616e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:administrativeGenderCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:administrativeGenderCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:birthTime
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:birthTime">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="not(*)">(COCT_MT030203): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:languageCode)&lt;=1">(COCT_MT030203): element hl7:languageCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:modeCode)&lt;=1">(COCT_MT030203): element hl7:modeCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:proficiencyLevelCode)&lt;=1">(COCT_MT030203): element hl7:proficiencyLevelCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:preferenceInd)&lt;=1">(COCT_MT030203): element hl7:preferenceInd komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:languageCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:languageCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:modeCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:modeCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:proficiencyLevelCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:proficiencyLevelCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:preferenceInd
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:preferenceInd">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="BL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule id="d852527e31-false-d852775e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person
Item: (COCT_MT040203)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT030203): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT030203): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:id)&gt;=1">(COCT_MT030203): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:administrativeGenderCode)&lt;=1">(COCT_MT030203): element hl7:administrativeGenderCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:birthTime)&lt;=1">(COCT_MT030203): element hl7:birthTime komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:id
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:name
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:name">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:administrativeGenderCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:administrativeGenderCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:birthTime
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:birthTime">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="not(*)">(COCT_MT030203): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:languageCode)&lt;=1">(COCT_MT030203): element hl7:languageCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:modeCode)&lt;=1">(COCT_MT030203): element hl7:modeCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:proficiencyLevelCode)&lt;=1">(COCT_MT030203): element hl7:proficiencyLevelCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:preferenceInd)&lt;=1">(COCT_MT030203): element hl7:preferenceInd komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:languageCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:languageCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:modeCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:modeCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:proficiencyLevelCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:proficiencyLevelCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:preferenceInd
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:preferenceInd">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="BL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:receiver/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:respondTo
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:respondTo" id="d850773e211-false-d853121e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="string(@typeCode)=('RSP') or not(@typeCode)">(MCCI_MT000300asynchroon): de waarde van @typeCode MOET 'RSP' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="not(@typeCode) or (string-length(@typeCode)&gt;0 and not(matches(@typeCode,'\s')))">(MCCI_MT000300asynchroon): attribuut @typeCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="count(hl7:entityRsp[not(@nullFlavor)])&gt;=1">(MCCI_MT000300asynchroon): element hl7:entityRsp[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="count(hl7:entityRsp[not(@nullFlavor)])&lt;=1">(MCCI_MT000300asynchroon): element hl7:entityRsp[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:respondTo/hl7:telecom
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:respondTo/hl7:telecom" id="d850773e213-false-d853155e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300asynchroon): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]" id="d850773e214-false-d853168e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="not(@classCode) or (string-length(@classCode)&gt;0 and not(matches(@classCode,'\s')))">(MCCI_MT000300asynchroon): attribuut @classCode MOET datatype 'cs' hebben</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@classCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.10882-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="not(@classCode) or count($theAttValue) = count($theAttCheck)">(MCCI_MT000300asynchroon): de waarde van classCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.10882' EntityClass (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="not(@determinerCode) or (string-length(@determinerCode)&gt;0 and not(matches(@determinerCode,'\s')))">(MCCI_MT000300asynchroon): attribuut @determinerCode MOET datatype 'cs' hebben</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@determinerCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.10878-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="not(@determinerCode) or count($theAttValue) = count($theAttCheck)">(MCCI_MT000300asynchroon): de waarde van determinerCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.10878' EntityDeterminer (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(MCCI_MT000300asynchroon): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]" id="d850773e219-false-d853228e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300asynchroon): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:name
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:name" id="d850773e220-false-d853241e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='EN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300asynchroon): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:EN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="EN"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:telecom
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:respondTo/hl7:entityRsp[not(@nullFlavor)]/hl7:telecom" id="d850773e221-false-d853254e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(MCCI_MT000300asynchroon): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.2
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]
Item: (MCCI_MT000300asynchroon)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]" id="d850773e222-false-d853268e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="string(@typeCode)=('SND') or not(@typeCode)">(MCCI_MT000300asynchroon): de waarde van @typeCode MOET 'SND' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="not(@typeCode) or (string-length(@typeCode)&gt;0 and not(matches(@typeCode,'\s')))">(MCCI_MT000300asynchroon): attribuut @typeCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="count(hl7:device[not(@nullFlavor)])&gt;=1">(MCCI_MT000300asynchroon): element hl7:device[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.2" test="count(hl7:device[not(@nullFlavor)])&lt;=1">(MCCI_MT000300asynchroon): element hl7:device[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]" id="d853278e22-false-d853300e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.6'])&gt;=1">(TransmissionWrapperDevice): element hl7:id[@root='2.16.840.1.113883.2.4.6.6'] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.6'])&lt;=1">(TransmissionWrapperDevice): element hl7:id[@root='2.16.840.1.113883.2.4.6.6'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:name)&lt;=1">(TransmissionWrapperDevice): element hl7:name komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:agencyFor)&lt;=1">(TransmissionWrapperDevice): element hl7:agencyFor komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.6']
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.6']" id="d853278e25-false-d853340e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@root)=('2.16.840.1.113883.2.4.6.6')">(TransmissionWrapperDevice): de waarde van @root MOET '2.16.840.1.113883.2.4.6.6' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="@extension">(TransmissionWrapperDevice): attribute @extension MOET aanwezig zijn.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:name
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:name" id="d853278e30-false-d853361e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='EN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:EN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="EN"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor" id="d853278e33-false-d853374e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('AGNT') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'AGNT' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:representedOrganization)&lt;=1">(TransmissionWrapperDevice): element hl7:representedOrganization komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization" id="d853278e37-false-d853396e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('ORG') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'ORG' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(TransmissionWrapperDevice): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(TransmissionWrapperDevice): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:id[not(@nullFlavor)])&lt;=1">(TransmissionWrapperDevice): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:NotificationParty)&lt;=1">(TransmissionWrapperDevice): element hl7:NotificationParty komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:id[not(@nullFlavor)]
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:id[not(@nullFlavor)]" id="d853278e40-false-d853447e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:name
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:name" id="d853278e43-false-d853460e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:telecom
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:telecom" id="d853278e46-false-d853473e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(TransmissionWrapperDevice): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.110
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty
Item: (TransmissionWrapperDevice)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty" id="d853278e49-false-d853487e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="string(@classCode)=('CON') or not(@classCode)">(TransmissionWrapperDevice): de waarde van @classCode MOET 'CON' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:contactParty)&gt;=1">(TransmissionWrapperDevice): element hl7:contactParty is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.110" test="count(hl7:contactParty)&lt;=1">(TransmissionWrapperDevice): element hl7:contactParty komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:id
Item: (COCT_MT040203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:id" id="d853493e18-false-d853536e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:code
Item: (COCT_MT040203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:code" id="d853493e19-false-d853549e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:addr
Item: (COCT_MT040203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:addr" id="d853493e20-false-d853562e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:telecom
Item: (COCT_MT040203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:telecom" id="d853493e21-false-d853575e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT040203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty
Item: (COCT_MT040203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty" id="d853493e22-false-d853588e0">
        <let name="elmcount" value="count(hl7:Organization|hl7:Person)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="$elmcount&gt;=1">(COCT_MT040203): keuze (hl7:Organization of hl7:Person) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="$elmcount&lt;=1">(COCT_MT040203): keuze (hl7:Organization of hl7:Person) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="count(hl7:Organization)&lt;=1">(COCT_MT040203): element hl7:Organization komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.516" test="count(hl7:Person)&lt;=1">(COCT_MT040203): element hl7:Person komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization
Item: (COCT_MT040203)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('ORG') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'ORG' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT150003): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:id)&gt;=1">(COCT_MT150003): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:code)&lt;=1">(COCT_MT150003): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:contact)&gt;=1">(COCT_MT150003): element hl7:contact is required [min 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:id
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:code
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:name
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:name">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('CON') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'CON' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:code)&lt;=1">(COCT_MT150003): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:contactPerson)&lt;=1">(COCT_MT150003): element hl7:contactPerson komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:id
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:code
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:addr
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:telecom
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson">
        <extends rule="d853812e22-false-d854506e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT150003): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT150003): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="count(hl7:name)&gt;=1">(COCT_MT150003): element hl7:name is required [min 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name">
        <extends rule="d854492e21-false-d854581e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId">
        <extends rule="d854492e31-false-d854740e0"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson
Item: (COCT_MT030203)
-->
    <rule id="d853812e22-false-d854506e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT030203): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT030203): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:id)&gt;=1">(COCT_MT030203): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:administrativeGenderCode)&lt;=1">(COCT_MT030203): element hl7:administrativeGenderCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:birthTime)&lt;=1">(COCT_MT030203): element hl7:birthTime komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:id
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:name
Item: (COCT_MT030203)
-->
    <rule id="d854492e21-false-d854581e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:administrativeGenderCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:administrativeGenderCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:birthTime
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:birthTime">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="not(*)">(COCT_MT030203): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:languageCode)&lt;=1">(COCT_MT030203): element hl7:languageCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:modeCode)&lt;=1">(COCT_MT030203): element hl7:modeCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:proficiencyLevelCode)&lt;=1">(COCT_MT030203): element hl7:proficiencyLevelCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:preferenceInd)&lt;=1">(COCT_MT030203): element hl7:preferenceInd komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:languageCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:languageCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:modeCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:modeCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:proficiencyLevelCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:proficiencyLevelCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:preferenceInd
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:preferenceInd">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="BL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:languageCommunication/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:contactPerson/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule id="d854492e31-false-d854740e0" abstract="true">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:contact/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.517
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:templateId
Item: (COCT_MT150003)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Organization/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.517" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT150003): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.516
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person
Item: (COCT_MT040203)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@classCode)=('PSN') or not(@classCode)">(COCT_MT030203): de waarde van @classCode MOET 'PSN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="string(@determinerCode)=('INSTANCE') or not(@determinerCode)">(COCT_MT030203): de waarde van @determinerCode MOET 'INSTANCE' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:id)&gt;=1">(COCT_MT030203): element hl7:id is required [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:administrativeGenderCode)&lt;=1">(COCT_MT030203): element hl7:administrativeGenderCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:birthTime)&lt;=1">(COCT_MT030203): element hl7:birthTime komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:id
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:name
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:name">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:administrativeGenderCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:administrativeGenderCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:birthTime
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:birthTime">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="not(*)">(COCT_MT030203): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:languageCode)&lt;=1">(COCT_MT030203): element hl7:languageCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:modeCode)&lt;=1">(COCT_MT030203): element hl7:modeCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:proficiencyLevelCode)&lt;=1">(COCT_MT030203): element hl7:proficiencyLevelCode komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="count(hl7:preferenceInd)&lt;=1">(COCT_MT030203): element hl7:preferenceInd komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:languageCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:languageCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:modeCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:modeCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:proficiencyLevelCode
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:proficiencyLevelCode">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CE' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CE" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CE"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:preferenceInd
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:preferenceInd">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='BL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:BL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="BL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:languageCommunication/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.518
Context: /hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:templateId
Item: (COCT_MT030203)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:sender[not(@nullFlavor)]/hl7:device[not(@nullFlavor)]/hl7:agencyFor/hl7:representedOrganization/hl7:NotificationParty/hl7:contactParty/hl7:Person/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.518" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT030203): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.23
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess
Item: (RCMR_IN000102NL)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess" id="d836099e2053-false-d855089e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="string(@classCode)=('ACTN') or not(@classCode)">(RCMR_IN000102NL): de waarde van @classCode MOET 'ACTN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not(@classCode) or (string-length(@classCode)&gt;0 and not(matches(@classCode,'\s')))">(RCMR_IN000102NL): attribuut @classCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="string(@moodCode)=('EVN')">(RCMR_IN000102NL): de waarde van @moodCode MOET 'EVN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not(@moodCode) or (string-length(@moodCode)&gt;0 and not(matches(@moodCode,'\s')))">(RCMR_IN000102NL): attribuut @moodCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:code)&lt;=1">(RCMR_IN000102NL): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:effectiveTime)&lt;=1">(RCMR_IN000102NL): element hl7:effectiveTime komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:authorOrPerformer[not(@nullFlavor)])&gt;=1">(RCMR_IN000102NL): element hl7:authorOrPerformer[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:authorOrPerformer[not(@nullFlavor)])&lt;=1">(RCMR_IN000102NL): element hl7:authorOrPerformer[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:overseer)&lt;=1">(RCMR_IN000102NL): element hl7:overseer komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:subject[not(@nullFlavor)])&gt;=1">(RCMR_IN000102NL): element hl7:subject[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:subject[not(@nullFlavor)])&lt;=1">(RCMR_IN000102NL): element hl7:subject[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <let name="controlActProcess" value="."/>
        <let name="authorEntity" value="$controlActProcess/hl7:authorOrPerformer//hl7:*[lower-case(local-name())=('assigneddevice','assignedperson')][1]"/>
        <let name="authorDevice" value="$authorEntity[lower-case(local-name())='assigneddevice']"/>
        <let name="authorPerson" value="$authorEntity[lower-case(local-name())='assignedperson']"/>
        <let name="overseerPerson" value="$controlActProcess/hl7:overseer//hl7:*[lower-case(local-name())=('assignedentity','assignedperson')][1]"/>
        <let name="authorPath" value="string-join($authorEntity/ancestor-or-self::*/name(),'/')"/>
        <let name="overseerPath" value="string-join($overseerPerson/ancestor-or-self::*/name(),'/')"/>
        <let name="senderApplicationId" value="$controlActProcess/../hl7:sender/hl7:device/hl7:id[@root='2.16.840.1.113883.2.4.6.6']/@extension"/>
        <let name="authorApplicationId" value="$authorDevice/hl7:id[@root='2.16.840.1.113883.2.4.6.6']/@extension"/>
        <let name="overseerOrgId" value="$overseerPerson/hl7:Organization/hl7:id"/>
        <let name="authorOrgId" value="$authorEntity/hl7:Organization/hl7:id"/>
        <let name="interactionId" value="$controlActProcess/../local-name()"/>
        <let name="interactionVocabFile" value="'../vocab/2.16.840.1.113883.1.6.xml'"/>
        <let name="interactionVocab" value="if (doc-available($interactionVocabFile)) then doc($interactionVocabFile) else ()"/>
        <let name="interactionTrustLevel" value="$interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Vertrouwensniveau']/@value"/>
        <let name="interactionSendType" value="$interactionVocab/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Verzendtype']/@value"/>
        <let name="interactionTriggerEventCode" value="$interactionVocab/*/hl7:code[@code=$interactionId]/hl7:reference/@extension"/>
        <let name="messageTriggerEventCode" value="$controlActProcess/hl7:code/@code"/>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="$interactionVocab">(RCMR_IN000102NL): Control Act: <value-of select="$interactionVocabFile"/> niet gevonden. Controles gebaseerd op dit externe configuratiebestand zijn gedeactiveerd.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($controlActProcess/hl7:queryByParameter) or $controlActProcess[@moodCode='EVN']">(RCMR_IN000102NL): Control Act: <value-of select="local-name()"/>/@moodCode moet 'EVN' zijn bij queries</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($interactionVocab) or not($messageTriggerEventCode) or $interactionTriggerEventCode=$messageTriggerEventCode">(RCMR_IN000102NL): Control Act: <value-of select="local-name()"/>/code (Trigger Event) moet bij deze interactie '<value-of select="$interactionTriggerEventCode"/>' zijn, gevonden is echter '<value-of select="$messageTriggerEventCode"/>'</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($interactionVocab) or $authorPerson or not($interactionTrustLevel) or $interactionTrustLevel='Laag'">(RCMR_IN000102NL): Control Act: <value-of select="local-name()"/>/authorOrPerformer moet een persoon bevatten in berichten met vertrouwensniveau midden of hoog</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($interactionVocab) or $overseerPerson or empty($interactionTrustLevel) or $interactionTrustLevel='Laag'">(RCMR_IN000102NL): Control Act: <value-of select="local-name()"/>/overseer moet de mandaterende persoon bevatten in berichten met vertrouwensniveau midden of hoog</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($authorEntity//hl7:id[@root='2.16.840.1.113883.2.4.6.3']) or not($authorEntity/../(hl7:queryByParameter|hl7:subject)//hl7:*[@root='2.16.840.1.113883.2.4.6.3']) or $authorEntity/../../hl7:attentionLine">(RCMR_IN000102NL): Patiëntgebonden interacties, verzonden vanuit een patiëntenportaal (GBP), moeten een attentionLine hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($authorEntity//hl7:id[@root=('2.16.840.1.113883.2.4.3.11.7.3','2.16.528.1.1003.1.3.5.4.1')]) or not($authorEntity/../(hl7:queryByParameter|hl7:subject)//hl7:*[@root='2.16.840.1.113883.2.4.6.3']) or $authorEntity/../../hl7:attentionLine">(RCMR_IN000102NL): Patiëntgebonden interacties, verzonden vanuit het klantenloket (GBK), moeten een attentionLine hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="empty($senderApplicationId) or empty($authorApplicationId) or $senderApplicationId=$authorApplicationId or $senderApplicationId='1'">(RCMR_IN000102NL): Control Act: <value-of select="$authorPath"/>/id. Applicatie-id <value-of select="$authorApplicationId"/> komt niet overeen met Transmission-wrapper sender <value-of select="$senderApplicationId"/>.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($authorDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']) or $authorDevice/hl7:id[@root='2.16.528.1.1007.3.2']">(RCMR_IN000102NL): Control Act: <value-of select="$authorPath"/>/id moet tenminste het UZI-nummer systemen bevatten voor een XIS in een GBZ</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($authorDevice/hl7:id[@root='2.16.528.1.1007.3.2']) or $authorDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3' and @extension]">(RCMR_IN000102NL): Control Act: <value-of select="$authorPath"/>/id moet de zorgaanbieder van het XIS identificeren</assert>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($authorDevice) or $authorDevice/hl7:id[@root='2.16.840.1.113883.2.4.6.6'][@extension='1'] or $authorDevice/hl7:id[@root='2.16.528.1.1007.4'] or $authorDevice/hl7:Organization/hl7:id">(RCMR_IN000102NL): Control Act: <value-of select="$authorPath"/>/ moet een geïdentificeerde organisatie hebben, tenzij het de ZIM of het SBV-Z betreft.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($authorPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']) or $authorPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'][@code='P']">(RCMR_IN000102NL): Control Act: <value-of select="$authorPath"/>/code/@code moet "P" (Patiënt) zijn. Wettelijke vertegenwoordigers moet dit via het Klantenloket doen en kunnen dus niet als auteur optreden</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($authorPerson/hl7:id[@root=('2.16.840.1.113883.2.4.3.11.7.3','2.16.528.1.1003.1.3.5.4.1')]) or $authorPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'][@code='KLANTENLOKET']">(RCMR_IN000102NL): Control Act: <value-of select="$authorPath"/>/code/@code moet "KLANTENLOKET" zijn voor klantenloketmedewerkers</assert>
        <assert role="warning" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($authorPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $authorPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']">(RCMR_IN000102NL): Control Act: <value-of select="$authorPath"/>/code ontbreekt. Dit is alleen toegestaan als de rolcode 00.000 is.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($authorPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $authorOrgId[@root='2.16.528.1.1007.3.3' and @extension]">(RCMR_IN000102NL): Control Act: <value-of select="$authorPath"/>/Organization/id moet de zorgaanbieder van de persoon identificeren</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($authorPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']) or $authorOrgId[@root='2.16.840.1.113883.2.4.3.11.25']">(RCMR_IN000102NL): Control Act: <value-of select="$authorPath"/>/Organization/id/@root moet '2.16.840.1.113883.2.4.3.11.25' bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($authorPerson/hl7:id[@root=('2.16.840.1.113883.2.4.3.11','2.16.528.1.1003.1.3.5.4.1')]) or $authorOrgId[@root='2.16.840.1.113883.2.4.3.11'][@extension='7']">(RCMR_IN000102NL): Control Act: <value-of select="$authorPath"/>/Organization/id moet de Nictiz-klantenloket organisatie identificeren</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($overseerPerson/hl7:Organization[not(hl7:name)]/hl7:id[@root='2.16.528.1.1007.3.3'])">(RCMR_IN000102NL): Control Act: <value-of select="$authorPath"/>/Organization/name moet de zorgaanbieder/organisatienaam bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($overseerPerson/hl7:Organization[not(hl7:name)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11' and @extension='7'])">(RCMR_IN000102NL): Control Act: <value-of select="$authorPath"/>/Organization/name moet de Nictiz-klantenloket organisatienaam bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($overseerPerson) or $overseerPerson/hl7:code">(RCMR_IN000102NL): Control Act: <value-of select="$overseerPath"/>/code is verplicht</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($overseerPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']) or $overseerPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'][@code='P'] or $overseerPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.6']">(RCMR_IN000102NL): Control Act: <value-of select="$overseerPath"/>/code/@code moet "P" (Patiënt) zijn of een geldige waarde uit RoleCodeWettelijkeVertegenwoordigerNL</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($overseerPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $overseerPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson/hl7:name">(RCMR_IN000102NL): Control Act: <value-of select="$overseerPath"/>/assignedPrincipalChoiceList/assignedPerson/name is verplicht</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($overseerPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $overseerPerson/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']">(RCMR_IN000102NL): Control Act: <value-of select="$overseerPath"/>/Organization/id moet de zorgaanbieder van de persoon identificeren</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($overseerPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $overseerPerson/hl7:Organization/hl7:name">(RCMR_IN000102NL): Control Act: <value-of select="$overseerPath"/>//Organization/name moet de zorgaanbiedernaam bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($overseerPerson/hl7:id[@root='2.16.528.1.1007.3.1']) or $overseerPerson/hl7:Organization/hl7:addr/hl7:city">(RCMR_IN000102NL): Control Act: <value-of select="$overseerPath"/>/Organization/addr moet tennminste de vestigingsplaats bevatten</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not($overseerOrgId) or $authorOrgId[@root=$overseerOrgId/@root][@extension=$overseerOrgId/@extension] or $authorEntity[lower-case(local-name())='assigneddevice']">(RCMR_IN000102NL): Control Act: <value-of select="$overseerPath"/>/Organization/id. Organisatie van de overseer (<value-of select="$overseerOrgId/@root"/>#<value-of select="$overseerOrgId/@extension"/>) moet gelijk zijn aan die van de authorOrPerformer (<value-of select="$authorOrgId/@extension"/>)</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.23
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:code
Item: (RCMR_IN000102NL)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:code" id="d836099e2060-false-d855177e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(RCMR_IN000102NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="@nullFlavor or (@codeSystem='2.16.840.1.113883.1.18')">(RCMR_IN000102NL): de elementwaarde MOET een zijn van 'codeSystem '2.16.840.1.113883.1.18''.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.23
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:effectiveTime
Item: (RCMR_IN000102NL)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:effectiveTime" id="d836099e2065-false-d855196e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TS' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(RCMR_IN000102NL): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TS" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TS"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="not(*)">(RCMR_IN000102NL): <value-of select="local-name()"/> met datatype TS, MAG GEEN elementen bevatten.</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.500
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer
Item: (ControlActAuthorOrPerformer)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer" id="d855197e57-false-d855212e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="@typeCode">(ControlActAuthorOrPerformer): attribute @typeCode MOET aanwezig zijn.</assert>
        <let name="theAttValue" value="distinct-values(tokenize(normalize-space(@typeCode),' '))"/>
        <let name="theAttCheck" value="distinct-values(document('include/voc-2.16.840.1.113883.1.11.19080-2011-07-26T000000.xml')/*/valueSet/conceptList/concept[@code = $theAttValue]/@code)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="not(@typeCode) or count($theAttValue) = count($theAttCheck)">(ControlActAuthorOrPerformer): de waarde van typeCode MOET worden gekozen uit waardelijst '2.16.840.1.113883.1.11.19080' x_ParticipationAuthorPerformer (2011-07-26T00:00:00).</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="count(hl7:participant[not(@nullFlavor)])&gt;=1">(ControlActAuthorOrPerformer): element hl7:participant[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="count(hl7:participant[not(@nullFlavor)])&lt;=1">(ControlActAuthorOrPerformer): element hl7:participant[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.500
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]
Item: (ControlActAuthorOrPerformer)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]" id="d855197e64-false-d855248e0">
        <let name="elmcount" value="count(hl7:AssignedDevice|hl7:AssignedPerson)"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="$elmcount&gt;=1">(ControlActAuthorOrPerformer): keuze (hl7:AssignedDevice of hl7:AssignedPerson) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.500" test="$elmcount&lt;=1">(ControlActAuthorOrPerformer): keuze (hl7:AssignedDevice of hl7:AssignedPerson) bevat te veel elementen [max 1x]</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.500
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice
Item: (ControlActAuthorOrPerformer)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice
Item: (COCT_MT090300)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.2']|hl7:id[@root='2.16.840.1.113883.2.4.6.6']|hl7:id[@root='2.16.528.1.1007.4'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="$elmcount&gt;=1">(COCT_MT090300): keuze (hl7:id[@root='2.16.528.1.1007.3.2'] of hl7:id[@root='2.16.840.1.113883.2.4.6.6'] of hl7:id[@root='2.16.528.1.1007.4']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="$elmcount&lt;=2">(COCT_MT090300): keuze (hl7:id[@root='2.16.528.1.1007.3.2'] of hl7:id[@root='2.16.840.1.113883.2.4.6.6'] of hl7:id[@root='2.16.528.1.1007.4']) bevat te veel elementen [max 2x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:Organization)&lt;=1">(COCT_MT090300): element hl7:Organization komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1010
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.528.1.1007.3.2']
Item: (dtUZIsystemen)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.528.1.1007.3.2']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1010" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtUZIsystemen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.UZI"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1010" test="string(@root)=('2.16.528.1.1007.3.2')">(dtUZIsystemen): de waarde van @root MOET '2.16.528.1.1007.3.2' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1008
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.840.1.113883.2.4.6.6']
Item: (dtAortaApplicationId)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.840.1.113883.2.4.6.6']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1008" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtAortaApplicationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1008" test="string(@root)=('2.16.840.1.113883.2.4.6.6')">(dtAortaApplicationId): de waarde van @root MOET '2.16.840.1.113883.2.4.6.6' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1018
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.528.1.1007.4']
Item: (dtSBV-Zsystemen)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:id[@root='2.16.528.1.1007.4']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1018" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtSBV-Zsystemen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1018" test="string(@root)=('2.16.528.1.1007.4')">(dtSBV-Zsystemen): de waarde van @root MOET '2.16.528.1.1007.4' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization
Item: (COCT_MT090300)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id[@root='2.16.528.1.1007']|hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']|hl7:id[@root='2.16.840.1.113883.2.4.3.11'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="$elmcount&gt;=1">(COCT_MT090300): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="$elmcount&lt;=1">(COCT_MT090300): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:code)&lt;=1">(COCT_MT090300): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:name[not(@nullFlavor)])&gt;=1">(COCT_MT090300): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:name[not(@nullFlavor)])&lt;=1">(COCT_MT090300): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:addr)&lt;=1">(COCT_MT090300): element hl7:addr komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1011
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (dtURAorganization)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtURAorganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.URA"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="string(@root)=('2.16.528.1.1007.3.3')">(dtURAorganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1019
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007']
Item: (dtSBV-ZOrganizationId)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.528.1.1007']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtSBV-ZOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@root)=('2.16.528.1.1007')">(dtSBV-ZOrganizationId): de waarde van @root MOET '2.16.528.1.1007' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@extension)=('4')">(dtSBV-ZOrganizationId): de waarde van @extension MOET '4' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1020
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']
Item: (dtGBO-GBP)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBO-GBP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="string(@root)=('2.16.840.1.113883.2.4.3.11.25')">(dtGBO-GBP): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.25' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1021
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11']
Item: (dtGBKOrganizationId)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBKOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@root)=('2.16.840.1.113883.2.4.3.11')">(dtGBKOrganizationId): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@extension)=('7')">(dtGBKOrganizationId): de waarde van @extension MOET '7' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id
Item: (COCT_MT090300)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:code
Item: (COCT_MT090300)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(COCT_MT090300): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.1 RoleCodeNL - zorgaanbiedertype (organisaties) (DYNAMISCH)'.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:telecom
Item: (COCT_MT090300)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:name[not(@nullFlavor)]
Item: (COCT_MT090300)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:name[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:addr
Item: (COCT_MT090300)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:city[not(@nullFlavor)])&gt;=1">(COCT_MT090300): element hl7:city[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="count(hl7:city[not(@nullFlavor)])&lt;=1">(COCT_MT090300): element hl7:city[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:Organization/hl7:addr/hl7:city[not(@nullFlavor)]
Item: (COCT_MT090300)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.513
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:templateId
Item: (COCT_MT090300)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedDevice/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.513" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090300): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.500
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson
Item: (ControlActAuthorOrPerformer)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.1']|hl7:id[@root='2.16.840.1.113883.2.4.6.3']|hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']|hl7:id[@root='2.16.528.1.1003.1.3.5.4.1'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&gt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id[@root='2.16.840.1.113883.2.4.6.3'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3'] of hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&lt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id[@root='2.16.840.1.113883.2.4.6.3'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3'] of hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.1'])&lt;=1">(COCT_MT090100): element hl7:id[@root='2.16.840.1.113883.2.4.6.1'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:code)&lt;=1">(COCT_MT090100): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:telecom)&lt;=1">(COCT_MT090100): element hl7:telecom komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPrincipalChoiceList)&lt;=1">(COCT_MT090100): element hl7:assignedPrincipalChoiceList komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:Organization[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:Organization[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:Organization[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:Organization[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1009
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.528.1.1007.3.1']
Item: (dtUZIpersonen)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.528.1.1007.3.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1009" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtUZIpersonen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.UZI"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1009" test="string(@root)=('2.16.528.1.1007.3.1')">(dtUZIpersonen): de waarde van @root MOET '2.16.528.1.1007.3.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1012
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']
Item: (dtBSN)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtBSN): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.BSN"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="string(@root)=('2.16.840.1.113883.2.4.6.3')">(dtBSN): de waarde van @root MOET '2.16.840.1.113883.2.4.6.3' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$')">(dtBSN): attribuut @root MOET datatype 'oid' hebben</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1015
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']
Item: (dtBatchInzageAuteur)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1015" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtBatchInzageAuteur): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1015" test="string(@root)=('2.16.840.1.113883.2.4.3.11.7.3')">(dtBatchInzageAuteur): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.7.3' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1016
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']
Item: (dtNictizKlantenloketPKIO)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1016" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtNictizKlantenloketPKIO): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1016" test="string(@root)=('2.16.528.1.1003.1.3.5.4.1')">(dtNictizKlantenloketPKIO): de waarde van @root MOET '2.16.528.1.1003.1.3.5.4.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1017
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.1']
Item: (dtAGB)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:id[@root='2.16.840.1.113883.2.4.6.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1017" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtAGB): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.AGB"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1017" test="string(@root)=('2.16.840.1.113883.2.4.6.1')">(dtAGB): de waarde van @root MOET '2.16.840.1.113883.2.4.6.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:code
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.4-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.5-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(COCT_MT090100): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.2 RoleCodeNL - zorgverlenertype (personen) (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.102.11.4 RoleCodeNL - toegang patiënt (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.102.11.5 RoleCodeNL - wettelijke vertegenwoording (DYNAMISCH)'.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="not(@code='00.000' and @codeSystem='2.16.840.1.113883.2.4.15.111')">(COCT_MT090100): Control Act: <name path=".."/>/<name/> moet een UZI-rolcode 00.000 is niet toegestaan</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:telecom
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPerson[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:assignedPerson[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPerson[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:assignedPerson[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id[@root='2.16.528.1.1007']|hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']|hl7:id[@root='2.16.840.1.113883.2.4.3.11'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&gt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&lt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:code)&lt;=1">(COCT_MT090100): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:addr)&lt;=1">(COCT_MT090100): element hl7:addr komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1011
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (dtURAorganization)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtURAorganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.URA"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="string(@root)=('2.16.528.1.1007.3.3')">(dtURAorganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1019
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007']
Item: (dtSBV-ZOrganizationId)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtSBV-ZOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@root)=('2.16.528.1.1007')">(dtSBV-ZOrganizationId): de waarde van @root MOET '2.16.528.1.1007' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@extension)=('4')">(dtSBV-ZOrganizationId): de waarde van @extension MOET '4' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1020
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']
Item: (dtGBO-GBP)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBO-GBP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="string(@root)=('2.16.840.1.113883.2.4.3.11.25')">(dtGBO-GBP): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.25' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1021
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11']
Item: (dtGBKOrganizationId)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBKOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@root)=('2.16.840.1.113883.2.4.3.11')">(dtGBKOrganizationId): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@extension)=('7')">(dtGBKOrganizationId): de waarde van @extension MOET '7' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:code
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(COCT_MT090100): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.1 RoleCodeNL - zorgaanbiedertype (organisaties) (DYNAMISCH)'.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:telecom
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:addr
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:city)&lt;=1">(COCT_MT090100): element hl7:city komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor)]/hl7:addr/hl7:city
Item: (COCT_MT090100)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:templateId
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant[not(@nullFlavor)]/hl7:AssignedPerson/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.502
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer
Item: (ControlActOverseerPersonMcaiMfmi)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer" id="d856340e40-false-d856353e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.502" test="string(@typeCode)=('RESP')">(ControlActOverseerPersonMcaiMfmi): de waarde van @typeCode MOET 'RESP' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.502
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]
Item: (ControlActOverseerPersonMcaiMfmi)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.1']|hl7:id[@root='2.16.840.1.113883.2.4.6.3']|hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']|hl7:id[@root='2.16.528.1.1003.1.3.5.4.1'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&gt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id[@root='2.16.840.1.113883.2.4.6.3'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3'] of hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&lt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.1'] of hl7:id[@root='2.16.840.1.113883.2.4.6.3'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3'] of hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:id[@root='2.16.840.1.113883.2.4.6.1'])&lt;=1">(COCT_MT090100): element hl7:id[@root='2.16.840.1.113883.2.4.6.1'] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:code)&lt;=1">(COCT_MT090100): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:telecom)&lt;=1">(COCT_MT090100): element hl7:telecom komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPrincipalChoiceList)&lt;=1">(COCT_MT090100): element hl7:assignedPrincipalChoiceList komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:Organization[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:Organization[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:Organization[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:Organization[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1009
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.1']
Item: (dtUZIpersonen)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1009" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtUZIpersonen): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.UZI"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1009" test="string(@root)=('2.16.528.1.1007.3.1')">(dtUZIpersonen): de waarde van @root MOET '2.16.528.1.1007.3.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1012
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.3']
Item: (dtBSN)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtBSN): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.BSN"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="string(@root)=('2.16.840.1.113883.2.4.6.3')">(dtBSN): de waarde van @root MOET '2.16.840.1.113883.2.4.6.3' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1012" test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$')">(dtBSN): attribuut @root MOET datatype 'oid' hebben</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1015
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']
Item: (dtBatchInzageAuteur)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.7.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1015" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtBatchInzageAuteur): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1015" test="string(@root)=('2.16.840.1.113883.2.4.3.11.7.3')">(dtBatchInzageAuteur): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.7.3' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1016
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']
Item: (dtNictizKlantenloketPKIO)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1003.1.3.5.4.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1016" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtNictizKlantenloketPKIO): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1016" test="string(@root)=('2.16.528.1.1003.1.3.5.4.1')">(dtNictizKlantenloketPKIO): de waarde van @root MOET '2.16.528.1.1003.1.3.5.4.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1017
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.1']
Item: (dtAGB)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.6.1']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1017" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtAGB): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.AGB"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1017" test="string(@root)=('2.16.840.1.113883.2.4.6.1')">(dtAGB): de waarde van @root MOET '2.16.840.1.113883.2.4.6.1' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:code
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.4-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]]) or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.102.11.5-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(COCT_MT090100): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.2 RoleCodeNL - zorgverlenertype (personen) (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.102.11.4 RoleCodeNL - toegang patiënt (DYNAMISCH) of 2.16.840.1.113883.2.4.3.11.60.102.11.5 RoleCodeNL - wettelijke vertegenwoording (DYNAMISCH)'.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="not(@code='00.000' and @codeSystem='2.16.840.1.113883.2.4.15.111')">(COCT_MT090100): Control Act: <name path=".."/>/<name/> moet een UZI-rolcode 00.000 is niet toegestaan</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:telecom
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:assignedPrincipalChoiceList
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:assignedPrincipalChoiceList">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPerson[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:assignedPerson[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:assignedPerson[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:assignedPerson[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:assignedPrincipalChoiceList/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='PN' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:PN" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="PN.NL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]">
        <let name="elmcount" value="count(hl7:id[@root='2.16.528.1.1007.3.3']|hl7:id[@root='2.16.528.1.1007']|hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']|hl7:id[@root='2.16.840.1.113883.2.4.3.11'])"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&gt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te weinig elementen [min 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="$elmcount&lt;=1">(COCT_MT090100): keuze (hl7:id[@root='2.16.528.1.1007.3.3'] of hl7:id[@root='2.16.528.1.1007'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] of hl7:id[@root='2.16.840.1.113883.2.4.3.11']) bevat te veel elementen [max 1x]</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:code)&lt;=1">(COCT_MT090100): element hl7:code komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&gt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:name[not(@nullFlavor)])&lt;=1">(COCT_MT090100): element hl7:name[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:addr)&lt;=1">(COCT_MT090100): element hl7:addr komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1011
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.3']
Item: (dtURAorganization)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007.3.3']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtURAorganization): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II.NL.URA"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1011" test="string(@root)=('2.16.528.1.1007.3.3')">(dtURAorganization): de waarde van @root MOET '2.16.528.1.1007.3.3' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1019
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007']
Item: (dtSBV-ZOrganizationId)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.528.1.1007']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtSBV-ZOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@root)=('2.16.528.1.1007')">(dtSBV-ZOrganizationId): de waarde van @root MOET '2.16.528.1.1007' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1019" test="string(@extension)=('4')">(dtSBV-ZOrganizationId): de waarde van @extension MOET '4' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1020
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']
Item: (dtGBO-GBP)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBO-GBP): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1020" test="string(@root)=('2.16.840.1.113883.2.4.3.11.25')">(dtGBO-GBP): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11.25' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.1021
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11']
Item: (dtGBKOrganizationId)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id[@root='2.16.840.1.113883.2.4.3.11']">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(dtGBKOrganizationId): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@root)=('2.16.840.1.113883.2.4.3.11')">(dtGBKOrganizationId): de waarde van @root MOET '2.16.840.1.113883.2.4.3.11' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.1021" test="string(@extension)=('7')">(dtGBKOrganizationId): de waarde van @extension MOET '7' zijn.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:id">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:code
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:code">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='CV' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:CV" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="CV"/>
        <let name="theCode" value="@code"/>
        <let name="theCodeSystem" value="@codeSystem"/>
        <let name="theCodeSystemVersion" value="@codeSystemVersion"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.4.3.11.60.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion] or completeCodeSystem[@codeSystem=$theCodeSystem][not(@codeSystemVersion) or @codeSystemVersion=$theCodeSystemVersion]])">(COCT_MT090100): de elementwaarde MOET een zijn van '2.16.840.1.113883.2.4.3.11.60.1.11.1 RoleCodeNL - zorgaanbiedertype (organisaties) (DYNAMISCH)'.</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:telecom
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:telecom">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='TEL' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:TEL" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="TEL"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='ON' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:ON" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="ON"/>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:addr
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:addr">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='AD' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:AD" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="AD"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="count(hl7:city)&lt;=1">(COCT_MT090100): element hl7:city komt te vaak voor [max 1x].</assert>
    </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:Organization[not(@nullFlavor)]/hl7:addr/hl7:city
Item: (COCT_MT090100)
-->

<!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.11.60.102.10.514
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:templateId
Item: (COCT_MT090100)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson[not(@nullFlavor)]/hl7:templateId">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.11.60.102.10.514" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(COCT_MT090100): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.23
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:subject[not(@nullFlavor)]
Item: (RCMR_IN000102NL)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:subject[not(@nullFlavor)]" id="d836099e2078-false-d857018e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:document[not(@nullFlavor)])&gt;=1">(RCMR_IN000102NL): element hl7:document[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.23" test="count(hl7:document[not(@nullFlavor)])&lt;=1">(RCMR_IN000102NL): element hl7:document[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.1
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:subject[not(@nullFlavor)]/hl7:document[not(@nullFlavor)]
Item: (RCMR_MT000102NL.Document)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:subject[not(@nullFlavor)]/hl7:document[not(@nullFlavor)]" id="d857035e11-false-d857043e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.1" test="string(@classCode)=('DOC')">(RCMR_MT000102NL.Document): de waarde van @classCode MOET 'DOC' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.1" test="not(@classCode) or (string-length(@classCode)&gt;0 and not(matches(@classCode,'\s')))">(RCMR_MT000102NL.Document): attribuut @classCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.1" test="string(@moodCode)=('EVN')">(RCMR_MT000102NL.Document): de waarde van @moodCode MOET 'EVN' zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.1" test="not(@moodCode) or (string-length(@moodCode)&gt;0 and not(matches(@moodCode,'\s')))">(RCMR_MT000102NL.Document): attribuut @moodCode MOET datatype 'cs' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.1" test="count(hl7:id[not(@nullFlavor)])&gt;=1">(RCMR_MT000102NL.Document): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.1" test="count(hl7:id[not(@nullFlavor)])&lt;=1">(RCMR_MT000102NL.Document): element hl7:id[not(@nullFlavor)] komt te vaak voor [max 1x].</assert>
    </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.4.3.111.3.9.10.1
Context: /hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:subject[not(@nullFlavor)]/hl7:document[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (RCMR_MT000102NL.Document)
-->
    <rule context="/hl7:RCMR_IN000102NL/hl7:ControlActProcess/hl7:subject[not(@nullFlavor)]/hl7:document[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]" id="d857035e14-false-d857078e0">
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.1" test="(local-name-from-QName(resolve-QName(@xsi:type,.))='II' and namespace-uri-from-QName(resolve-QName(@xsi:type,.))='urn:hl7-org:v3') or not(@xsi:type)">(RCMR_MT000102NL.Document): indien er een @xsi:type instructie aanwezig is MOET deze de waarde "{urn:hl7-org:v3}:II" bevatten, gevonden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
        <extends rule="II"/>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.1" test="@extension">(RCMR_MT000102NL.Document): attribute @extension MOET aanwezig zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.1" test="not(@extension) or string-length(@extension)&gt;0">(RCMR_MT000102NL.Document): attribuut @extension MOET datatype 'st' hebben</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.1" test="@root">(RCMR_MT000102NL.Document): attribute @root MOET aanwezig zijn.</assert>
        <assert role="error" see="http://decor.nictiz.nl/art-decor/decor-templates--vwi-?id=2.16.840.1.113883.2.4.3.111.3.9.10.1" test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(RCMR_MT000102NL.Document): attribuut @root MOET datatype 'uid' hebben</assert>
    </rule>
</pattern>